let property = require('common/property');
let dcw = require('../widget-helper');

let settings = require('./channel-settings');
let cs = settings.load();

// throw JSON.stringify(parameters);
// let external = parameters.external;

/**
 * Converts an object to a string representation.
 * If the object has a specific structure, it will be converted using the `property.from` method.
 * @param {Object} obj - The object to convert to a string.
 * @returns {string} The string representation of the object.
 */
function stringify(obj) {
  if (obj === null) return 'null';
  if (typeof obj === 'object') {
    if (Object.keys(obj).indexOf('className') > -1 && obj.name && obj.ID) {
      return property
        .from({
          name: obj.name,
          ID: obj.ID,
          UUID: obj.UUID,
          className: obj.className,
        })
        .toPrettyString();
    } else {
      let out;
      try {
        out = property.from(obj).toPrettyString();
      } catch (err) {
        return 'null';
      }
      return out;
    }
  }
  return obj;
}

/**
 * Determines whether a given reference is an object.
 * @memberof path
 * @function isObject
 * @param {*} ref - The reference to check.
 * @returns {boolean} True if the reference is an object with a className property, false otherwise.
 */
function isObject(ref) {
  return typeof ref === 'object' && 'className' in ref;
}

let buttons = [
  {
    name: 'btnClear',
    type: 'agorum.button',
    text: 'Clear buffer',
    // icon: 'aguila-icon-yes'
  },
  {
    name: 'btnUpdate',
    type: 'agorum.button',
    text: 'Update buffer',
  },
  {
    name: 'btnSettings',
    type: 'agorum.button',
    text: 'Settings',
    // icon: 'aguila-icon-yes'
  },
];

let aon = {
  type: 'agorum.border',
  width: 506,
  height: 640,
  docked: {
    top: {
      type: 'agorum.toolbar',
      items: buttons,
    },
    center: {
      type: 'agorum.textArea',
      name: 'logWindow',
      monospace: true,
      flexible: true,
    },
  },
};

let dw = dcw.create(aon);

let logOut = [];

function printMsg(msg) {
  let sep = cs.separator;
  // let separator = (sep.repeat > 0) ? sep.data[sep.selected].text.repeat(sep.repeat) : null;
  let separator = sep.repeat > 0 ? sep.value.repeat(sep.repeat) : null;
  let text = cs.stringify && isObject(msg.text) ? stringify(msg.text) : msg.text;

  if (cs.mode === 0) {
    // insert log message at the beginning
    if (separator) logOut.unshift(separator);
    logOut.unshift(text);
  } else {
    // append log message
    if (separator) logOut.push(separator);
    logOut.push(text);
  }
  dw.items.logWindow.value = logOut.join('\n');
}

let handlers = {
  log: msg => {
    printMsg(msg);
  },
};

dw.widget.sub(cs.channel, msg => {
  handlers[msg.type](msg);
});

dw.items.btnSettings.on('clicked', () => {
  let sw = dcw.create(settings.aon);
  settings.init(sw, cs);
  sw.widget.popup({ title: 'Settings', modal: true });
  sw.widget.on('destroying', () => {
    settings.update(sw, cs);
  });
});

dw.items.btnClear.on('clicked', () => {
  logOut = [];
  dw.items.logWindow.value = logOut.join('\n');
});

dw.items.btnUpdate.on('clicked', () => {
  logOut = dw.items.logWindow.value.split('\n');
  // dw.items.logWindow.value =  logOut.join('\n');
});

dw.widget.on('destroyed', () => {
  // metadb.write(settingsPath, JSON.stringify(cs));
});

setImmediate(() => {
  dw.widget.title = '';
});
/*
setImmediate(() => {
  dw.widget.form.title = cs.title;
});
*/
dw.widget;
